const file = document.getElementById('file');
const canvas = document.getElementById('out');
const ctx = canvas.getContext('2d');
let img = new Image();

file.addEventListener('change', e=>{
  const f = e.target.files[0];
  if(!f) return;
  img.src = URL.createObjectURL(f);
  img.onload = ()=> {
    canvas.width = img.naturalWidth;
    canvas.height = img.naturalHeight;
    ctx.drawImage(img,0,0);
  }
});

function getDominantEdgeColor(imgData, w, h){
  let r=0,g=0,b=0,count=0;
  const d = imgData.data;

  function samplePixel(x,y){
    const i = (y*w + x)*4;
    r+=d[i]; g+=d[i+1]; b+=d[i+2]; count++;
  }

  for(let x=0;x<w;x++){
    samplePixel(x,0);
    samplePixel(x,h-1);
  }
  
  for(let y=0;y<h;y++){
    samplePixel(0,y);
    samplePixel(w-1,y);
  }

  return {r:Math.round(r/count), g:Math.round(g/count), b:Math.round(b/count)};
}

document.getElementById('process').addEventListener('click', ()=>{
  if(!img.src) return alert('Please upload an image first.');
  ctx.drawImage(img,0,0);
  const id = ctx.getImageData(0,0,canvas.width,canvas.height);
  const d = id.data;

  const bg = getDominantEdgeColor(id, canvas.width, canvas.height);
  const tol = Number(document.getElementById('tol').value);

  for(let i=0;i<d.length;i+=4){
    const r=d[i], g=d[i+1], b=d[i+2];
    const dist = Math.sqrt((r-bg.r)**2 + (g-bg.g)**2 + (b-bg.b)**2);
    if(dist < tol){
      d[i+3] = 0; 
    }
  }
  ctx.putImageData(id,0,0);
});

document.getElementById('download').addEventListener('click', ()=>{
  if(!canvas.width) return alert('Nothing to download');
  const a = document.createElement('a');
  a.href = canvas.toDataURL('image/png');
  a.download = 'removed-bg.png';
  a.click();
});